unit ftd2xx;
////////////////////////////////////////////////////////////////////////////////
//
//      Unit for direct FTDI USD devices support from FTDI Chip
//
//          For latest version visit www.ftdichip.com please...
//
////////////////////////////////////////////////////////////////////////////////

//  VERSION CORRECTED BY SLEO 14.03.2008 (using ftd2xx.h dated 02.02.2007)

                               interface
////////////////////////////////////////////////////////////////////////////////
uses
  Windows;

type
  FT_STATUS = integer;
  FT_DEVICE = DWORD;
  
  FT_PROGRAM_DATA = record
    Signature1: DWORD;          // Header - must be 0x00000000
    Signature2: DWORD;          // Header - must be 0xffffffff
    Version: DWORD;             // Header - FT_PROGRAM_DATA version
                                // 0 = original
                                // 1 = FT2232C extensions
                                // 2 = FT232R extensions
    //
    VendorID: WORD;             // 0x0403
    ProductId: WORD;            // 0x6001
    Manufacturer: PChar;        // "FTDI"
    ManufacturerID: PChar;      // "FT"
    Description: PChar;         // "USB HS Serial Converter"
    SerialNumber: PChar;        // "FT000001" if fixed, or NULL
    MaxPower: WORD;             // 0 < MaxPower <= 500
    PnP: WORD;                  // 0 = disabled, 1 = enabled
    SelfPowered: WORD;          // 0 = bus powered, 1 = self powered
    RemoteWakeup: WORD ;        // 0 = not capable, 1 = capable
    // Rev4 extensions
    Rev4: bytebool;             // true if Rev4 chip, false otherwise
    IsoIn: bytebool;            // true if in endpoint is isochronous
    IsoOut: bytebool;           // true if out endpoint is isochronous
    PullDownEnable: bytebool;   // true if pull down enabled
    SerNumEnable: bytebool;     // true if serial number to be used
    USBVersionEnable: bytebool; // true if chip uses USBVersion
    USBVersion: WORD;           // BCD (0x0200 => USB2)
    // FT2232C extensions
    Rev5: byte;                 // non-zero if Rev5 chip, zero otherwise
    IsoInA: byte;               // non-zero if in endpoint is isochronous
    IsoInB: byte;               // non-zero if in endpoint is isochronous
    IsoOutA: byte;              // non-zero if out endpoint is isochronous
    IsoOutB: byte;              // non-zero if out endpoint is isochronous
    PullDownEnable5: byte;      // non-zero if pull down enabled
    SerNumEnable5: byte;        // non-zero if serial number to be used
    USBVersionEnable5: byte;    // non-zero if chip uses USBVersion
    USBVersion5: WORD;          // BCD (0x0200 => USB2)
    AIsHighCurrent: byte;       // non-zero if interface is high current
    BIsHighCurrent: byte;       // non-zero if interface is high current
    IFAIsFifo: byte;            // non-zero if interface is 245 FIFO
    IFAIsFifoTar: byte;         // non-zero if interface is 245 FIFO CPU target
    IFAIsFastSer: byte;         // non-zero if interface is Fast serial
    AIsVCP: byte;               // non-zero if interface is to use VCP drivers
    IFBIsFifo: byte;            // non-zero if interface is 245 FIFO
    IFBIsFifoTar: byte;         // non-zero if interface is 245 FIFO CPU target
    IFBIsFastSer: byte;         // non-zero if interface is Fast serial
    BIsVCP: byte;               // non-zero if interface is to use VCP drivers
    // FT232R extensions
    UseExtOsc: byte;            // Use External Oscillator
    HighDriveIOs: byte;         // High Drive I/Os
    EndpointSize: byte;         // Endpoint size
    PullDownEnableR: byte;      // non-zero if pull down enabled
    SerNumEnableR: byte;        // non-zero if serial number to be used
    InvertTXD: byte;            // non-zero if invert TXD
    InvertRXD: byte;            // non-zero if invert RXD
    InvertRTS: byte;            // non-zero if invert RTS
    InvertCTS: byte;            // non-zero if invert CTS
    InvertDTR: byte;            // non-zero if invert DTR
    InvertDSR: byte;            // non-zero if invert DSR
    InvertDCD: byte;            // non-zero if invert DCD
    InvertRI: byte;             // non-zero if invert RI
    Cbus0: byte;                // Cbus Mux control - Ignored for FT245R
    Cbus1: byte;                // Cbus Mux control - Ignored for FT245R
    Cbus2: byte;                // Cbus Mux control - Ignored for FT245R
    Cbus3: byte;                // Cbus Mux control - Ignored for FT245R
    Cbus4: byte;                // Cbus Mux control - Ignored for FT245R
    RIsVCP: byte;               // non-zero if using VCP drivers
  end;

const

  FT_DLL_NAME = 'ftd2xx.dll';

  // Result  Values
  FT_OK = 0;
  FT_SUCCESS = FT_OK;
  FT_INVALID_HANDLE = 1;
  FT_DEVICE_NOT_FOUND = 2;
  FT_DEVICE_NOT_OPENED = 3;
  FT_IO_ERROR = 4;
  FT_INSUFFICIENT_RESOURCES = 5;
  FT_INVALID_PARAMETER = 6;
  FT_INVALID_BAUD_RATE = 7;
  FT_DEVICE_NOT_OPENED_FOR_ERASE = 8;
  FT_DEVICE_NOT_OPENED_FOR_WRITE = 9;
  FT_FAILED_TO_WRITE_DEVICE = 10;
  FT_EEPROM_READ_FAILED = 11;
  FT_EEPROM_WRITE_FAILED = 12;
  FT_EEPROM_ERASE_FAILED = 13;
  FT_EEPROM_NOT_PRESENT = 14;
  FT_EEPROM_NOT_PROGRAMMED = 15;
  FT_INVALID_ARGS = 16;
  FT_NOT_SUPPORTED = 17;
  FT_OTHER_ERROR = 18;

  // FT_ListDevices Flags
  FT_LIST_NUMBER_ONLY = $80000000;
  FT_LIST_BY_INDEX = $40000000;
  FT_LIST_ALL = $20000000;

  // FT_Open_Ex Flags
  FT_OPEN_BY_SERIAL_NUMBER = 1;
  FT_OPEN_BY_DESCRIPTION = 2;

  // Baud Rate Selection
  FT_BAUD_300 = 300;
  FT_BAUD_600 = 600;
  FT_BAUD_1200 = 1200;
  FT_BAUD_2400 = 2400;
  FT_BAUD_4800 = 4800;
  FT_BAUD_9600 = 9600;
  FT_BAUD_14400 = 14400;
  FT_BAUD_19200 = 19200;
  FT_BAUD_38400 = 38400;
  FT_BAUD_57600 = 57600;
  FT_BAUD_115200 = 115200;
  FT_BAUD_230400 = 230400;
  FT_BAUD_460800 = 460800;
  FT_BAUD_921600 = 921600;

  // Data Bits Selection
  FT_DATA_BITS_7 = 7;
  FT_DATA_BITS_8 = 8;

  // Stop Bits Selection
  FT_STOP_BITS_1 = 0;
  FT_STOP_BITS_2 = 2;

  // Parity Selection
  FT_PARITY_NONE = 0;
  FT_PARITY_ODD = 1;
  FT_PARITY_EVEN = 2;
  FT_PARITY_MARK = 3;
  FT_PARITY_SPACE = 4;

  // Flow Control Selection
  FT_FLOW_NONE = $0000;
  FT_FLOW_RTS_CTS = $0100;
  FT_FLOW_DTR_DSR = $0200;
  FT_FLOW_XON_XOFF = $0400;

  // Purge Commands
  FT_PURGE_RX = 1;
  FT_PURGE_TX = 2;


// "Classic Interface" Functions

function FT_ListDevices(pvArg1, pvArg2: Pointer; dwFlags: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_ListDevices';
function FT_Open(iDevice: integer; var ftHandle: THandle): FT_STATUS; stdcall; external  FT_DLL_NAME name 'FT_Open';
function FT_OpenEx(pvArg1: pointer; dwFlags: DWORD; var ftHandle: THandle): FT_STATUS; stdcall ; external FT_DLL_NAME name 'FT_OpenEx';
function FT_Close(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_Close';
function FT_Read(ftHandle: THandle; lpBuffer: pointer; dwBytesToRead: DWORD; var lpdwBytesReturned: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_Read';
function FT_Write(ftHandle: THandle; lpBuffer: pointer; dwBytesToWrite: DWORD; var lpdwBytesWritten: DWORD): FT_STATUS; stdcall ; external FT_DLL_NAME name 'FT_Write';
function FT_ResetDevice(ftHandle: THandle): FT_STATUS; stdcall ; external FT_DLL_NAME name 'FT_ResetDevice';
function FT_SetBaudRate(ftHandle: THandle; dwBaudRate: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetBaudRate';
function FT_SetDataCharacteristics(ftHandle: THandle; uWordLength, uStopBits, uParity: BYTE): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetDataCharacteristics';
function FT_SetFlowControl(ftHandle: THandle; wFlowControl: WORD; uXon, uXoff: BYTE): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetFlowControl';
function FT_SetDTR(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetDtr';
function FT_ClrDTR(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_ClrDtr';
function FT_SetRTS(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetRts';
function FT_ClrRTS(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_ClrRts';
function FT_SetChars(ftHandle: THandle; uEventChar, uEventCharEn, uErrorChar, uErrorCharEn: BYTE): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetChars';
function FT_Purge(ftHandle: THandle; dwMask: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_Purge';
function FT_SetTimeouts(ftHandle: THandle; dwReadTimeout, dwWriteTimeout: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetTimeouts';
function FT_GetQueueStatus(ftHandle: THandle; var AmountInRXQueue: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_GetQueueStatus';
function FT_SetBreakOn(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetBreakOn';
function FT_SetBreakOff(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetBreakOff';
function FT_GetStatus(ftHandle: THandle; var lpdwAmountInRxQueue: DWORD; var lpdwAmountInTxQueue: DWORD; var lpdwEventStatus): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_GetStatus';


// EEPROM Programming Interface Functions
function FT_EE_Program(ftHandle: THandle; var lpData: FT_PROGRAM_DATA): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_EE_Program';
function FT_EE_Read(ftHandle: THandle; var lpData: FT_PROGRAM_DATA): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_EE_Read';
function FT_EE_UARead(ftHandle: THandle; pucData: pointer; dwDataLen: DWORD; var lpdwBytesRead: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_EE_UARead';
function FT_EE_UAWrite(ftHandle: THandle; pucData: pointer; dwDataLen: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_EE_UAWrite';

function FT_ReadEE(ftHandle: THandle; dwWordOffset: DWORD; var lpwValue: WORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_ReadEE';
function FT_WriteEE(ftHandle: THandle; dwWordOffset: DWORD; wValue: WORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_WriteEE';
function FT_EraseEE(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_EraseEE';

//
function FT_SetLatencyTimer(ftHandle: THandle; ucLatency: byte): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetLatencyTimer';
function FT_GetLatencyTimer(ftHandle: THandle; var ucLatency: byte): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_GetLatencyTimer';

function FT_SetBitMode(ftHandle: THandle; ucMask: byte;ucEnable: byte): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetBitMode';
function FT_GetBitMode(ftHandle: THandle; var pucMode: byte): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_GetBitMode';

function FT_SetUSBParameters(ftHandle: THandle; ulInTransferSize: DWORD; ulOutTransferSize: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetUSBParameters';

function FT_SetDeadmanTimeout(ftHandle: THandle; ulDeadmanTimeout: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetDeadmanTimeout';

function FT_GetDeviceInfo(ftHandle: THandle; var lpftDevice: FT_DEVICE; var lpdwID: DWORD; SerialNumber: PChar; Description: PChar; Dummy: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_GetDeviceInfo';

function FT_StopInTask(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_StopInTask';
function FT_RestartInTask(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_RestartInTask';

function FT_SetResetPipeRetryCount(ftHandle: THandle; dwCount: DWORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_SetResetPipeRetryCount';
function FT_ResetPort(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_ResetPort';
function FT_CyclePort(ftHandle: THandle): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_CyclePort';

function FT_Rescan(): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_Rescan';
function FT_Reload(wVid: WORD; wPid: WORD): FT_STATUS; stdcall; external FT_DLL_NAME name 'FT_Reload';



implementation


end.
